<?php
/**
 * LightOpenID 1.2
 * Librería mínima OpenID para PHP
 * https://gitorious.org/lightopenid/mainline
 */

class LightOpenID
{
    public $returnUrl;
    public $required = array();
    public $optional = array();
    public $identity;
    public $trustRoot;
    public $realm;
    public $mode;
    public $ns = 'http://specs.openid.net/auth/2.0';

    public function __construct($host)
    {
        $this->trustRoot = 'http://'.$host.'/';
        $this->returnUrl = $this->trustRoot;
    }

    public function authUrl()
    {
        $params = array(
            'openid.ns' => $this->ns,
            'openid.mode' => 'checkid_setup',
            'openid.return_to' => $this->returnUrl,
            'openid.trust_root' => $this->trustRoot,
            'openid.identity' => $this->identity,
            'openid.claimed_id' => $this->identity
        );

        return 'https://steamcommunity.com/openid/login?' . http_build_query($params);
    }

    public function validate()
    {
        $params = $_GET;
        $params['openid.mode'] = 'check_authentication';
        $ch = curl_init('https://steamcommunity.com/openid/login');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        $res = curl_exec($ch);
        curl_close($ch);

        if (strpos($res, "is_valid:true") !== false) {
            return true;
        }
        return false;
    }
}
?>
