<?php
session_start();
require "../steam/SteamOpenID.php";
require "../config/conexion.php";

// URL de retorno de Steam después del login
$returnUrl = "https://banscs.bond/cs/banscs/admin/dashboard.php";
$steam = new SteamOpenID($returnUrl);

// Si no hay modo OpenID en la URL, redirigimos al login de Steam
if (!isset($_GET["openid_mode"])) {
    header("Location: " . $steam->loginUrl());
    exit;
}

// Validamos SteamID64
$steamID64 = $steam->validate();
if (!$steamID64) {
    die("Error autenticando con Steam");
}

// Buscamos al usuario en la base de datos
$check = $conexion->prepare("SELECT * FROM usuarios WHERE steam64 = ?");
$check->bind_param("s", $steamID64);
$check->execute();
$res = $check->get_result();

if ($res->num_rows === 1) {
    // Usuario existente
    $user = $res->fetch_assoc();
    $_SESSION["usuario"] = $user["usuario"];
    $_SESSION["rol"] = $user["rol"];
    $_SESSION["steamid"] = $steamID64;

    session_regenerate_id(true); // Previene fijación de sesión
    header("Location: admin/dashboard1111.php");
    exit;
} else {
    // Usuario nuevo
    $nuevoUser = "steam_" . substr($steamID64, -6);
    
    // Rol por defecto seguro (no moderador automáticamente)
    $rol = "usuario"; 

    $sql = $conexion->prepare("INSERT INTO usuarios (usuario, steam64, password, rol) VALUES (?, ?, '', ?)");
    $sql->bind_param("sss", $nuevoUser, $steamID64, $rol);
    if (!$sql->execute()) {
        die("Error al crear usuario: " . $conexion->error);
    }

    $_SESSION["usuario"] = $nuevoUser;
    $_SESSION["rol"] = $rol;
    $_SESSION["steamid"] = $steamID64;

    session_regenerate_id(true); // Previene fijación de sesión
    header("Location: admin/dashboard111.php");
    exit;
}
